<?php

namespace backend\controllers;

use Yii;
use backend\models\Academico;
use backend\models\AcademicoSearch;

use backend\models\Carga;
use backend\models\CargaSearch;

use backend\models\Tercero;
use backend\models\Asistencia;
use backend\models\AsistenciaSearch;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\TipoInasistencia;
use backend\models\Calificacion;


use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\data\ActiveDataProvider;
use yii\base\Model;


/**
 * AcademicoController implements the CRUD actions for Academico model.
 */
class DocenteController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Academico models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Carga::find()->where(['docente' => Yii::$app->session->get('__tercero')]),
            'pagination' => [
                'pageSize' => 30,
            ],
        ]);
   
        $periodo = new Periodo();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'periodo' => $periodo,
            
        ]);
    }

    public function actionAsistencia()
    {

        
        $dataProvider = new ActiveDataProvider([
            'query' => Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','calificacion.calificacion'])->joinWith(['estudiantes','calificaciones'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')]),
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);

        $periodo = new Periodo();

       // $registros = Asistencia::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Asistencia', []));
        

        $asistencias = [new Asistencia()];

        for($i = 1; $i < $count; $i++) {
            $asistencias[] = new Asistencia();
        }

        if (Model::loadMultiple($asistencias, Yii::$app->request->post()) 
            && Model::validateMultiple($asistencias)) 
        {

            $contar = 0;

            foreach ($asistencias as $model) {
                
                if ($model->asistio==1) {
                    $model->fecha = new \yii\db\Expression('NOW()');
                    $model->save();

                    $contar++;
                }

            }

            Yii::$app->session->addFlash('db', [
                            'tipo' => 'info',
                            'titulo' => 'Asistencias',
                            'icono' => 'fa fa-user',
                            'mensaje' => 'Se almacenaron '.$contar.' inasistencias al sistema.']); 

            return $this->redirect(['index']); // redirect to your next desired page
        } else {
            return $this->render('asistencia', [
                'dataProvider'=>$dataProvider,
                'asistencias' => $asistencias,
                'periodo' => $periodo,
            ]);
        }
    }    

    public function actionColor($calificacion)
    {
        $color ='#ccc;';
                    
        if ($calificacion!='')
        {   
            $query = "SELECT * FROM `desempeno` WHERE ".$calificacion." BETWEEN limite_inferior AND limite_superior";
            $desempeno = Desempeno::findbySql($query)->one();
            $color = $desempeno['color'];
        }
        return $color;
    }

    public function actionCalificaciones()
    {

        $dataProvider = new ActiveDataProvider([
            'query' => Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo','calificacion.calificacion'])->joinWith(['estudiantes','calificaciones'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')]),
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);
        $periodo = new Periodo();

        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Calificacion', []));
        
        $grupo = Grupo::find()->where(['id' => $_GET['grupo']])->one();

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
    
        $calificaciones = [new Calificacion()]; 


        for($i = 1; $i < $count; $i++) {

            $calificaciones[] = new Calificacion();
        }

        if (Model::loadMultiple($calificaciones, Yii::$app->request->post()) 
            && Model::validateMultiple($calificaciones))     
        {

            foreach ($calificaciones as $calificacion) {
                  
                $reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->actual->id])->one();
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();


                if(count($reg) == '0')
                {   
                    $model= new Calificacion;
                    
                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->calificacion = $calificacion->calificacion;
                        }
                        else // POR COMPETENCIA
                        {
                            $model->calificacion = implode(",", $calificacion->calificacion);
                        }    
                    
                    $model->coevaluacion = $calificacion->coevaluacion;
                    $model->autoevaluacion = $calificacion->autoevaluacion;
                    $model->heteroevaluacion = $calificacion->heteroevaluacion;
                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                        
                        if($model->save(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' no se almacenaron en el sistema',
                            ]);
                        }
                }
                else
                {  
                    $model= Calificacion::find()->where(['id' => $reg->id])->one();


                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->calificacion = $calificacion->calificacion;
                        }
                        else // POR COMPETENCIA
                        {
                            $model->calificacion = implode(",", $calificacion->calificacion);
                        } 
                    
                    $model->coevaluacion = $calificacion->coevaluacion;
                    $model->autoevaluacion = $calificacion->autoevaluacion;
                    $model->heteroevaluacion = $calificacion->heteroevaluacion;

                    
                    
                        if($model->update(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'info',
                                'titulo' => 'No hubo cambios!',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'No hubo cambios en las calificaciones de '.$estudiante->nombre.' por eso no se actualizaron en el sistema',
                            ]);
                        }
                    
                }    
            }

            return $this->redirect(['index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'registros' => $registros,
                'grupo' => $grupo,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
            ]);
        }
    }    

     public function actionFindfallas() 
     {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $fallas_id = $parents[0];
                $out= ($fallas_id ==0) ? NULL : [['id' => 1, 'name' => '1 Hora'], ['id' => 2, 'name' => '2 Horas'], ['id' => 3, 'name' => '3 Horas'], ['id' => 4, 'name' => '4 Horas'], ['id' => 5, 'name' => '5 Horas']];
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }


     public function actionFindtiposfallas() {
    
        $out = [];
        if (isset($_POST['depdrop_parents'])) {
            $parents = $_POST['depdrop_parents'];
            if ($parents != null) {
                $asistio_id = $parents[0];
                $out=Tipoinasistencia::getTipoinasistencia($asistio_id);
                
                return json_encode(['output'=>$out, 'selected'=>'']);
            }
        }
        return json_encode(['output'=>'', 'selected'=>'']);
    }


    public function actionAddAsistencia()
    {
        if (Yii::$app->request->isAjax) {
            $row = Yii::$app->request->post('Calificacion');
            if((Yii::$app->request->post('isNewRecord') && Yii::$app->request->post('action') == 'load' && empty($row)) || Yii::$app->request->post('action') == 'add')
                $row[] = [];
            return $this->renderAjax('_list_asistencia', ['row' => $row]);
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }    
}